<?php

namespace AMLA\APIMobileBundle\TraitRepository;

use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;

use AMLA\WebBundle\Entity\GastraceCard;
use AMLA\WebBundle\Entity\User;
use AMLA\ApiBundle\Common\Api\SqrApi;


/**
 * GastraceCardTRepository
 */
trait GastraceCardTRepository
{

    private function entityManager()
    {
        return $this->getEntityManager();
    }

    /**
     * Activate gastrace card
     *
     * @param $cardCode
     * @param User $user
     * @return User
     */
    public function apiActivateCard($cardCode, User $user)
    {
        $result = null;
        $em = $this->entityManager();

        $card = $this->apiFindCard($cardCode);

        // Merge
        $card->setConsumer($user);
        $card->setStatus(1);

        // Call sqr api and generate smart card
        $sqrApi = new SqrApi($this->container);
        $sqrResult = $sqrApi->updateCard($card);

        if($sqrResult != null){
            $em->merge($card);
            $em->flush();

            $result = $card->getConsumer();
        }else{
            $result = $sqrResult;
        }

        return $result;
    }

    /**
     * Find gastrace card
     *
     * @param $query
     * @return GastraceCard|null
     */
    public function apiFindCard($query)
    {
        $result = null;
        $queryBuilder = $this->createQueryBuilder("card");

        // Options
        $queryBuilder->andWhere(
            $queryBuilder->expr()->orX(
                $queryBuilder->expr()->eq('card.' . GastraceCard::SQR, ':query'),
                $queryBuilder->expr()->eq('card.' . GastraceCard::NIU, ':query')
            )
        );
        // Parameters
        $queryBuilder->setParameter("query", $query);

        $query = $queryBuilder->getQuery();

        try{
            $result = $query->getSingleResult();
        }
        catch(NonUniqueResultException $e){
            $result = null;
        }
        catch(NoResultException $e){
            $result = null;
        }

        return $result;
    }

    /**
     * Create gastrace card for consumer
     *
     * @param $quantity
     * @return array
     */
    public function apiCreateCard($quantity)
    {
        $em = $this->entityManager();
        $cards = array();

        $quantity = (int) $quantity;

        if(is_int($quantity) && $quantity > 0){
            // Call sqr api and generate smart card
            $sqrApi = new SqrApi($this->container);

            if($this->container != null){
                for($i = 0; $i < $quantity; $i++){
                    $sqrResult = $sqrApi->createCard();
                    if($sqrResult != null){
                        $card = new GastraceCard(
                            $sqrResult['qr'],
                            $sqrResult['niu']
                        );

                        $em->persist($card);
                        $em->flush();

                        array_push($cards, $card);
                    }
                }
            }else{
                throw new \LogicException("Invalid container value is null");
            }
        }else{
            throw new \LogicException("Invalid quantity value");
        }

        return $cards;
    }

}