<?php

namespace AMLA\APIMobileBundle\Controller;

//use AMLA\ApiBundle\Exception\ResourceNotFoundException;
//use AMLA\ApiBundle\Model\Filter\QueryDataFilter;
//use AMLA\ApiBundle\Model\Representation\Impl\_GastraceCardResource;
//use AMLA\ApiBundle\Model\Representation\Impl\_Sell;
use AMLA\SqrBundle\Entity\EnregistrementPp;
use FOS\RestBundle\Controller\FOSRestController;
//use AMLA\ApiBundle\Common\Secure\TokenAuthenticated;
//use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;

/**
 * GastraceCardController
 */
class GastraceCardController extends FOSRestController
{

    //use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * Create gastrace card
     *
     * @Rest\Get(
     *    path = "create/",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200)
     * @param $quantity
     * @param Request $request
     * @return array of coupons
     */
    public function addGastraceCardAction($quantity, Request $request)
    {
        $this->checkApiAccess($request);
        $em = $this->entityManager();

        $repo = $em->getRepository(sprintf(Constants::WEB_REPO, "GastraceCard"));
        $repo->setContainer($this->container);

        $responseData = $repo->apiCreateCard($quantity);
        return $responseData;
    }

    
    /**
     * Find gastrace card
     *
     * @Rest\Get(
     *    path = "get",
     *    name = ""
     * )
     * @Rest\QueryParam(
     *     name="query",
     *     default=null,
     *     description="Query key word"
     * )
     * @Rest\View(StatusCode = 200)
     * @param ParamFetcherInterface $paramFetcher
     * @param Request $request
     * @return GastraceCard|null
     * @throws ResourceNotFoundException
     * @throws \AMLA\ApiBundle\Exception\ForBiddenException
     */
    public function apiFindCardAction(ParamFetcherInterface $paramFetcher, Request $request)
    {
        $this->checkApiAccess($request);
        $em = $this->entityManager();

        $repo = $em->getRepository(sprintf(Constants::WEB_REPO, "GastraceCard"));
        $response = $repo->apiFindCard($paramFetcher->get("query"));

        if($response == null)
            throw new ResourceNotFoundException(sprintf("Unknown card"));

        return $response;
    }

}